<?php
	// Exit if accessed directly
	if( !defined( 'ABSPATH' ) ) exit;

function wpforo_thread_topic_template( $topicid ){
    $thread = wpforo_thread( $topicid );
    if(empty($thread)) return;
    ?>
    <div class="wpf-thread <?php wpforo_topic_types($thread); wpforo_unread($topicid, 'topic'); ?>">
        <div class="wpf-thread-body">
            <div class="wpf-thread-box wpf-thread-status">
                <div class="wpf-thread-statuses" <?php echo $thread['wrap']; ?>><?php echo $thread['status_html']; ?></div>
            </div>
            <div class="wpf-thread-box wpf-thread-author">
                <?php echo $thread['author_html']; ?>
            </div>
            <div class="wpf-thread-box wpf-thread-title">
                <span class="wpf-thread-status-mobile"><?php wpforo_topic_icon($thread); ?> </span>
                <?php wpforo_topic_title($thread, $thread['url'], '{p}{au}{tc}{/a}{n}{v}', true, '', wpforo_setting( 'forums', 'layout_threaded_intro_topics_length' )) ?>
                <div class="wpf-thread-author-name">
                    <span><?php wpforo_phrase('by') ?></span> <?php wpforo_member_link( $thread['user'] ) ?>, <?php wpforo_date($thread['created'],'ago-date'); ?>&nbsp; <?php wpforo_tags($thread, true, 'text') ?>
                </div>
                <div class="wpf-thread-forum-mobile">
					<i class="<?php echo $thread['forum']['icon'] ?>" style="color: <?php echo $thread['forum']['color'] ?>"></i>&nbsp;
					<?php $forum_description = (wpfval($thread['forum'], 'description')) ? 'wpf-tooltip="' . esc_attr(strip_tags((string) $thread['forum']['description'])) . '"  wpf-tooltip-size="long"' : ''; ?>
					<a href="<?php echo esc_url((string) $thread['forum']['url']); ?>" <?php echo $forum_description ?>>
						<?php echo esc_attr($thread['forum']['title'])?>
					</a>
				</div>
            </div>
            <div class="wpf-thread-box wpf-thread-forum">
                <span style="font-size: 150%; opacity: 0.8; border: 2px solid <?php echo $thread['forum']['color'] ?>; border-radius: 50%; width: 44px; height: 44px; display: flex; justify-content: center; align-items: center;" wpf-tooltip="<?php echo esc_attr($thread['forum']['title'])?>" wpf-tooltip-position="left" wpf-tooltip-size="long"><i class="<?php echo $thread['forum']['icon'] ?>" style="color: <?php echo $thread['forum']['color'] ?>"></i></span>
            </div>
            <div class="wpf-thread-box wpf-thread-posts">
                <span><?php echo wpforo_print_number((intval($thread['posts']) - 1)) ?></span>
            </div>
            <div class="wpf-thread-box wpf-thread-views">
                <span><?php echo wpforo_print_number($thread['views']) ?></span>
            </div>
            <div class="wpf-thread-box wpf-thread-last-reply">
                <div class="wpf-thread-last-info">
                    <div class="wpf-thread-last-user">
                        <div class="wpf-thread-last-avatar"><?php echo $thread['reply_html'] ?></div>
                        <?php wpforo_member_link( $thread['last_user'], 'by', 14) ?>
                    </div>
                    <div class="wpf-thread-last-date"><?php wpforo_date($thread['modified']) ?></div>
                </div>
            </div>
        </div>
    </div>
    <?php
}
?>
